# AI 辅助工具集



你好，我是鱼皮。

在前面的文章中，我们学习了各种 AI 编程工具，包括 AI 零代码平台、AI 智能体平台、AI 代码编辑器、命令行工具、IDE 插件。但要真正高效地开发项目，光有 AI 工具还不够，还需要一些辅助工具来完善整个工作流程。

举些例子，你可能会遇到这些问题：

- AI 把代码改出问题了，怎么还原？
- 项目做完了，怎么部署上线让别人访问？
- 有没有其他实用的工具可以提升效率？

这篇文章，我会介绍 Vibe Coding 开发中常用的辅助工具，帮你完善整个开发工具链。



## 一、Git 版本管理

### 为什么需要 Git？

在开发过程中，你可能会遇到这些情况：

- 刚才改了代码，结果改坏了，想恢复到之前的版本
- 想尝试一个新功能，但又怕影响现有的代码
- 多人协作时，不知道谁改了什么

这些问题，Git 都能帮你解决。

**Git 是一个版本控制工具**，可以记录代码的每一次修改，随时回退到任何历史版本。

💡 如果你想成为一名专业的程序员，那么必学 Git，这是企业开发的基本功。



### Git 的核心概念

Git 的工作流程很简单，主要就三步：

1. 在工作区修改代码
2. 添加代码到暂存区（用 `git add` 命令）
3. 提交代码到仓库（用 `git commit` 命令）

打个比方，修改代码就像在草稿纸上写东西，添加到暂存区就像把满意的内容挑出来，提交到仓库就像把这些内容正式保存到笔记本里。

![](https://pic.yupi.icu/1/gitworkflow%E5%A4%A7.jpeg)



### 怎么使用 Git？

有 2 种使用 Git 的方式：**可视化工具** 和 **命令行**。

对于新手来说，我强烈推荐先用可视化工具。现在很多主流的开发工具（比如 Cursor、VS Code）都内置了 Git 功能，点几下鼠标就能完成代码的提交和拉取，完全不需要记命令。

我自己刚开始接触 Git 的时候就是这样，完全没有上网搜教程，就是看别人提交项目的时候在编辑器上点几下就搞定了，觉得很神奇。然后我就有样学样地用起了这个工具。而且很长一段时间我都是用 [GitHub Desktop](https://desktop.github.com/) 来傻瓜式操作，遇到问题了再上网搜解决方案。

![GitHub Desktop APP](https://pic.yupi.icu/1/screenshot-windows-dark.png)

等你熟练了之后，可以再学习命令行操作。命令行虽然看起来复杂，但其实更灵活、更强大，而且很多高级功能只能通过命令行实现。

下面是几个最常用的命令，学会这几个命令，就能应付 90% 的日常开发了。

```bash
# 克隆项目
git clone https://github.com/liyupi/ai-guide.git

# 查看状态
git status

# 添加文件
git add .

# 提交
git commit -m "添加了新功能"

# 推送到远程
git push

# 拉取最新代码
git pull
```

不用刻意去背，用到的时候查一下就行，或者直接问 AI。

这里我建议大家无论是否要学习 Git，都可以先把它安装到你的电脑中，[直接去官网安装](https://git-scm.com/) 就好。有可能一些软件或工具会依赖 Git，不装的话后面会出现一些问题。



### 实际使用场景

让我用一个实际例子来演示 Git 的用法。比如你用 Cursor 做了一个项目，想用 Git 管理版本。

1）首先在项目的根目录中执行命令来初始化 Git：

```bash
git init
```

2）然后添加所有文件并提交第一个版本：

```bash
git add .
git commit -m "初始版本"
```

3）接下来继续开发，修改了一些代码。修改完成后再次提交：

```bash
git add .
git commit -m "添加了用户登录功能"
```

4）如果某次修改出了问题，想回退到之前的版本，可以这样：

```bash
git log  # 查看历史，找到想回退的版本号
git reset --hard 版本号
```

Git 会帮你记录每一次修改，随时可以回退。



### Git 和 AI 工具的配合

现在很多 AI 工具都内置了 Git 功能。比如 Cursor 可以在编辑器里直接提交代码：

![](https://pic.yupi.icu/1/image-20260109110826513.png)

也可以让 AI 帮你自动执行 Git 命令，就跟它说 “帮我用 Git 来管理项目” 就可以了。

此外，AI 还能帮你生成提交信息，一切皆可 Vibe Coding！

我建议大家养成一个习惯：**每完成一个功能，就提交一次**。

这样即使 AI 改坏了代码，也能随时恢复到之前的版本。有了 Git，你就可以放心大胆地让 AI 改代码了，反正随时能回退。



### 学习建议

Git 的功能很强大，但对于 Vibe Coding 来说，掌握上面这些用法就够用了。如果想深入学习 Git 和 GitHub，可以看看鱼皮写的 [Git & GitHub 学习路线](https://www.codefather.cn/course/1789189862986850306/section/1789190804671012866)。这个学习路线从零基础到精通，涵盖了 Git 的所有核心知识点，而且完全免费。



## 二、部署托管平台

你用 AI 做好了项目，虽然在本地运行得很好，但如果想让别人也能访问，就需要把项目部署到服务器上。

传统的部署方式很复杂：要租服务器、配置环境、上传代码、配置域名等等。但现在有很多免费的部署平台，可以让你几分钟就把项目上线。



### Vercel

[Vercel](https://vercel.com) 是目前最流行的前端部署平台，特别适合 React、Next.js、Vue、静态网站等前端项目。

优点是个人项目完全免费，部署速度极快（一般 1 ~ 2 分钟），自动配置 HTTPS 和 CDN 加速；还和 GitHub 深度集成，能够在你推送代码后自动部署。

使用 Vercel 超级简单。

1）首先访问 [Vercel 官网](https://vercel.com) 注册账号，建议使用 GitHub 账号注册登录。

2）创建项目，可以直接绑定 GitHub 并选择已经托管的项目，点击 "Deploy" 部署按钮：

![](https://pic.yupi.icu/1/image-20260109111323983.png)

3）等待 1 ~ 2 分钟，项目就上线了！

部署成功后 Vercel 会自动给你一个域名，比如 `your-project.vercel.app`，你也可以绑定自己的域名。

而且每次你往 GitHub 推送代码，Vercel 都会自动重新部署，完全不用手动操作。

💡 具体过程可以看鱼皮的视频教程：https://www.bilibili.com/video/BV1TV4y1j76t



### Netlify

[Netlify](https://www.netlify.com/) 和 Vercel 类似，但功能更全面一些。支持更多的框架和静态站点生成器，有表单处理、无服务器函数等功能，免费额度更大、还支持 A/B 测试和分析。使用方式和 Vercel 类似，不过多介绍了。



### EdgeOne Pages 国产部署平台

[EdgeOne Pages](https://pages.edgeone.ai) 是腾讯云推出的边缘全栈开发平台，它基于腾讯云 EdgeOne 基础设施，提供从前端页面到动态 API 的无服务器部署体验。


EdgeOne 是腾讯云的边缘安全加速平台，简单来说就是 “网络加速 + 安全防护” 的组合。它利用腾讯遍布全球的网络节点，让你的网站在离用户更近的地方提供服务，加载速度更快。同时还集成了 Web 防护能力，可以在边缘就过滤拦截恶意流量，保护你的网站安全。

EdgeOne Pages 基于这个强大的基础设施，优点是国内访问速度快，和腾讯云服务深度集成，支持边缘函数，有免费额度。更适合国产开发者宝宝们~



### GitHub Pages

[GitHub Pages](https://pages.github.com/) 是 GitHub 提供的免费静态网站托管服务。优点是完全免费、无限流量、和 GitHub 无缝集成。

使用方法巨简单，在 GitHub 创建仓库并上传网站文件后，直接在仓库设置中启用 GitHub Pages：

![](https://pic.yupi.icu/1/image-20260109111917547.png)

然后就能通过 `username.github.io/repo-name` 访问了。适合个人主页、项目文档、简单的静态网站。



### 如何选择？

- 如果你的项目是 Next.js，选 Vercel（官方推荐）
- 如果是其他前端框架或静态网站，Vercel 和 Netlify 都可以
- 如果是国内用户，想要更快的访问速度，选 EdgeOne Pages
- 如果只是简单的静态页面，GitHub Pages 最简单

我自己主要用 Vercel + EdgeOne Pages，因为它速度快、体验好。国内项目会用 EdgeOne Pages，访问速度确实快很多。



### Cloudflare CDN

如果你想让网站访问速度更快，还可以使用 [Cloudflare](https://www.cloudflare.com/zh-cn/) 的免费 CDN 服务。

CDN（内容分发网络）就是把你的网站内容缓存到全球各地的服务器上，用户访问时会自动选择离他最近的服务器，大大提高加载速度。

![](https://pic.yupi.icu/1/1763643073516-5248d56c-bf7d-4537-b8f8-681a104626d9.png)

Cloudflare 的优势是：

- 完全免费（个人网站）
- 全球 CDN 加速，覆盖 200+ 个城市
- 自动 HTTPS 证书
- DDoS 防护和 Web 防火墙
- 免费的 DNS 服务

使用方法很简单，注册 Cloudflare 账号，添加你的域名，然后把域名的 DNS 服务器改成 Cloudflare 提供的地址就行。Cloudflare 会自动帮你加速和保护网站。

也可以直接使用 Cloudflare 提供的 Pages 页面部署能力，直接上传自己的代码，交给它一键部署并白票免费的域名，更方便~

![](https://pic.yupi.icu/1/1763643412558-4d499b46-5e16-4f83-9df7-06a85175df35.png)

如果你的网站部署在 Vercel 或 Netlify 上，它们本身就有 CDN 加速，不需要额外配置 Cloudflare。但如果你是自己租服务器部署，强烈建议用 Cloudflare 加速。 



### 更多部署方式

鱼皮分享过多种快速部署上线项目的视频教程：

- [Vercel 项目部署教程](https://www.bilibili.com/video/BV1TV4y1j76t)
- [云端编辑器 + Vercel + 对象存储 + 内网穿透 4 种方式部署](https://www.bilibili.com/video/BV1UZ4y197i1)
- [Nginx + 宝塔 2 种方式部署个人博客](https://www.bilibili.com/video/BV1rU4y1J785)
- [WordPress 搭建个人博客](https://www.bilibili.com/video/BV14q4y1R7XM)
- [4 种主流前后端项目部署](https://www.codefather.cn/course/1790943469757837313/section/1791075571845345281?contentType=video&tabKey=videoList)

此外，鱼皮在 [编程导航](https://codefather.cn/) 带大家做过 20 多套项目了，几乎每种部署方式都给大家讲解过，如果你想成为一名专业的程序员，建议学习一下。

- [AI 零代码应用生成平台项目](https://www.codefather.cn/course/1948291549923344386)：1Panel 面板 + Nginx 前端 + Java 后端（jar 包）
- [代码生成器共享平台项目](https://www.codefather.cn/course/1790980795074654209)：宝塔面板 + Nginx 前端 + Java 项目管理器（jar 包）后端部署
- [AI 答题应用平台项目](https://www.code-nav.cn/course/1790274408835506178)： Vercel 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [AI 超级智能体项目](https://www.codefather.cn/course/1915010091721236482)：Docker 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [OJ 在线判题项目](https://www.codefather.cn/course/1790980707917017089)：Docker Compose 后端微服务部署

基本上学会这几种部署方式，能够应对绝大多数部署需求了。



## 三、MCP 服务 - 扩展 AI 能力

MCP（Model Context Protocol） 是一个开放标准，可以让 AI 工具连接到各种外部工具和数据源。

简单来说，MCP 就像给 AI 装上了各种 "插件"，让它能做更多事情。比如文件系统 MCP 让 AI 可以读写文件，GitHub MCP 让 AI 可以操作 GitHub 仓库，数据库 MCP 让 AI 可以查询数据库，浏览器 MCP 让 AI 可以浏览网页。

![](https://pic.yupi.icu/1/mcp.png)

现在几乎所有主流 AI 编程工具都支持 MCP，包括 Cursor、Claude Code、Cline、Windsurf、Gemini CLI、Kiro 等。你可以在这些工具中使用各种 MCP 服务，大大扩展 AI 的能力。

下面我用 Cursor 作为例子，演示如何配置和使用 MCP。



### 在 Cursor 中使用 MCP

让我用一个实际例子来演示如何在 Cursor 中配置和使用 MCP。

比如我希望让 Cursor 能够得知当前准确的时间。

1）利用 MCP 大全网站搜索你需要的 MCP 工具，并获取到 MCP 配置信息，后面会用到：

![](https://pic.yupi.icu/1/image-20260109113038258.png)

由于这个 MCP 工具需要用到 `uvx` 命令来安装，我们需要先安装 uv 工具。参考 [官方安装文档](https://docs.astral.sh/uv/getting-started/installation/)，选择操作系统并执行一行命令，就能完成安装了。

![](https://pic.yupi.icu/1/image-20260109113308798.png)

安装后，执行 `uvx` 命令，应该会看到下图的输出，表示安装成功：

![](https://pic.yupi.icu/1/image-20260109113427041.png)



2）打开 Cursor 设置，找到 MCP 配置选项，点击添加 MCP：

![](https://pic.yupi.icu/1/image-20260109113809834.png)



3）Cursor 是通过 JSON 文件来管理 MCP 的，添加前面复制的 MCP 服务器配置：

```json
{
  "mcpServers": {
    "time": {
      "command": "uvx",
      "args": [
        "mcp-server-time",
        "--local-timezone=America/New_York"
      ]
    }
  }
}
```

![](https://pic.yupi.icu/1/image-20260109112647904.png)



4）保存后，会发现 MCP 工具已成功开启，现在 AI 就可以获取到最新时间了。

![](https://pic.yupi.icu/1/image-20260109113524465.png)



5）你可以问 AI：现在几点钟？

AI 就能通过调用 MCP，给你最准确的时间。

![](https://pic.yupi.icu/1/image-20260109113631840.png)



还有更多常用的 MCP 服务器，比如：

- @modelcontextprotocol/server-filesystem：文件系统访问
- @modelcontextprotocol/server-github：GitHub 操作
- @modelcontextprotocol/server-postgres：数据库查询
- @modelcontextprotocol/server-puppeteer：浏览器自动化



如果你想了解更多 MCP 服务，可以访问：

- [鱼皮 AI 导航的 MCP 大全](https://ai.codefather.cn/)：整理了各种实用的 MCP 服务
- [mcp.so](https://mcp.so/)：MCP 服务器市场，可以找到各种 MCP 服务
- [GitHub awesome-mcp-servers](https://github.com/punkpeye/awesome-mcp-servers)：社区维护的 MCP 服务器列表

这些网站会持续更新最新的 MCP 服务，建议收藏。



## 四、其他实用工具

除了版本管理、部署平台和 MCP，还有一些其他实用工具值得了解。



### GitHub 代码托管

[GitHub](https://github.com/liyupi) 是全球最大的代码托管平台，不仅可以托管代码，还能和全球优秀的开发者交流 ♂。

你可以在 GitHub 上托管代码、展示项目、学习别人的代码、参与开源项目。而且很多 AI 工具都支持和 GitHub 集成，比如 Cursor、Vercel、Netlify 等。

![鱼皮 GitHub 的项目仓库](https://pic.yupi.icu/1/image-20251126231252956.png)

个人建议，给自己的每个项目都创建一个 GitHub 仓库，既能备份代码，又能展示作品。



### 图床工具

如果你的项目需要图片，就会遇到一个问题：图片放哪里？

直接放在项目里会让项目变得很大，而且如果把图片文件放到自己的小水管服务器上，加载速度会比较慢。这时候就需要用到图床工具了。

**图床工具就是专门用来存储和管理图片的服务**，你把图片上传上去，它会给你一个链接，你在项目里用这个链接就行。

图床工具分两种：**在线图床 **和 **本地图床工具**。

在线图床就是直接在网页上传图片，比如 [imgchr](https://imgchr.com/)，优点是简单方便，缺点是可能不太稳定。

我更推荐用 [PicGo](https://molunerfinn.com/PicGo/)，这是一个本地图床工具，支持多种图床平台（GitHub、七牛云、腾讯云、阿里云等）。你可以在本地管理图片，上传后自动复制链接，非常方便。

![](https://pic.yupi.icu/1/image-20260109114343606.png)

而且 PicGo 还支持快捷键上传、截图上传等功能，用起来特别顺手。如果你经常需要在文章或项目里插入图片，强烈推荐试试 PicGo。

鱼皮写文章一般是用 Typora 写作工具 + PicGo 上传图片，可以保证自己文章中的图片在任意电脑上都能访问。



### 环境变量管理

在项目中，你经常会用到一些敏感信息，比如 API Key、数据库密码等。千万不要直接写在代码里！不然别人一看你的代码，这些密钥就泄露了。

正确的做法是使用环境变量。在本地开发时，创建一个 `.env` 文件：

```
OPENAI_API_KEY=your_key_here
DATABASE_URL=your_database_url
```

然后在代码里通过 `process.env.OPENAI_API_KEY` 这样的方式来读取。

部署到 Vercel 或 Netlify 时，在它们的设置页面添加环境变量就行，不用把 `.env` 文件上传上去。这样既安全，又方便管理。



### 域名服务

简单来说，域名就是网站的地址。比如 `codefather.cn`、`dogyupi.com`。

如果你想让自己的项目有一个好记的网址，就需要购买一个域名，而不是直接让用户通过 IP 访问。

对于国内用户，我推荐在 [阿里云](https://wanwang.aliyun.com/) 或 [腾讯云](https://dnspod.cloud.tencent.com/) 这种知名云服务商购买域名。价格一般是几十块钱一年，而且操作界面都是中文的，很方便。

![](https://pic.yupi.icu/1/image-20260109114615834.png)

需要注意的是，**如果你的网站服务器在国内，域名需要备案**。备案流程大概需要 1 ~ 2 周，需要提供身份证、手机号等信息。

如果你的网站部署在 Vercel、Netlify 这些国外平台上，或者在国外平台购买域名，那么可以省去备案，快速上线。



### 数据库服务

数据库就是用来存储数据的地方。

比如你做一个待办事项应用，用户添加的待办事项就需要存到数据库里；你做一个博客网站，文章内容也需要存到数据库里。

对于 Vibe Coding 开发者来说，我强烈推荐 [Supabase](https://supabase.com/)。它是一个开源的数据库服务，提供了免费额度，而且功能非常强大：

- 提供 PostgreSQL 数据库（功能强大的关系型数据库）
- 内置用户认证功能（注册、登录、密码重置等）
- 提供文件存储功能，可以存图片、视频等
- 实时数据同步，数据变化时自动更新
- 友好的可视化界面，不用写 SQL 也能管理数据

![](https://pic.yupi.icu/1/image-20260109114906767.png)

而且 Supabase 的文档非常详细，配合 AI 工具使用特别方便。你只需要告诉 AI：“用 Supabase 做一个用户注册功能”，AI 就能帮你写好代码。

除了 Supabase，还有一些其他选择：

- PlanetScale：MySQL 数据库，有免费额度
- MongoDB Atlas：NoSQL 数据库，有免费额度

如果你想进一步快速学习数据库，可以看看 [鱼皮的数据库快速入门视频](https://www.bilibili.com/video/BV1iJSLBbEyD/)。



### 代码片段管理 - 代码小抄

在开发过程中，你可能会遇到一些好用的代码片段，想保存下来以后用。或者你遇到 Bug 了，想把代码分享给别人帮你看看。这时候就需要代码片段管理工具了。

我强烈推荐自己团队开发的 [代码小抄](https://codecopy.cn/)。这是一个简单易用的代码分享工具，可以快速、跨设备地自由分享代码。

![代码小抄](https://pic.yupi.icu/1/1705646241236-26786c47-1251-4891-85f3-e91ac9e4be94-20240125151504219-20240222165129145.png)

代码小抄的优势：

- 界面很像程序员常用的编辑器，可以新增、删除代码片段
- 支持多种分享范围（公开、加密、仅个人可见）
- 支持多种分享方式（复制链接、QQ 分享、手机扫码、微信小程序等）
- 还有代码库功能，可以查看并学习其他同学分享的优质代码
- 支持在线运行代码、AI 智能代码分析和纠错

无论是电脑或手机，都能获得不错的阅读体验。而且完全免费，不用担心代码泄露。

**求求了！找别人改 Bug 时，不要再拍模糊不清的照片、或者直接在聊天里发代码了**，用代码小抄分享，对方看起来会舒服很多。



### 图标库和素材

做网站或应用时，经常需要一些图标和图片素材。下面是一些免费的资源网站：

图标库：

- [iconfont](https://www.iconfont.cn/)：阿里巴巴矢量图标库，国内最大的图标库，完全免费
- [Font Awesome](https://fontawesome.com/)：国外流行的图标库，有免费版和付费版
- [Iconify](https://iconify.design/)：整合了多个图标库，一站式搜索

占位图：

- [Picsum Photos](https://picsum.photos/)：随机生成占位图，可以指定尺寸

免费图片：

- [Unsplash](https://unsplash.com/)：高质量免费图片，可商用
- [Pexels](https://www.pexels.com/)：免费图片和视频素材

这些资源都可以免费使用，而且质量很高。配合 AI 工具使用，可以快速做出漂亮的网站。



## 写在最后

OK，以上就是 Vibe Coding 开发中常用的辅助工具，相信大家已经疯狂收藏了。

刚开始学习时，可能会觉得要学的东西很多。但其实你不需要一次学会所有东西，可以循序渐进。遇到问题时，再去学习相应的工具，这样学习效率最高。

建议你尝试下载并使用 Git，把代码推送到 GitHub，然后部署到 Vercel。看着自己的项目在网上运行，并分享给朋友，简直成就感爆棚！



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
